<?php
/**
 * Plugin Name: Pochirin
 * Plugin URI: https://pochipp.com/
 * Description: RinkerデータをPochippに変換するプラグイン
 * Version: 0.1.2
 * Author: ひろ
 * Author URI: https://pochipp.com/
 * License: GPL3 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if ( ! defined( 'ABSPATH' ) ) exit;

add_action( 'init', 'Pochirin::init' );

class Pochirin {

	const VERSION        = '0.1.1';
	const MENU_SLUG      = 'pochirin';
	const AJAX_ACTION    = 'pochirin';
	const NONCE_KEY      = 'pochirin-nonce';
	const IS_TEST        = 0;
	const IS_TEST_ID     = 0; // テスト時に1記事だけコンテンツ変換するときのid
	const NUM_OF_CONVERT = -1; // テスト時に何件のデータをコンバートするか

	public static $is_changed = false;

	public static function init() {
		if ( class_exists( 'POCHIPP' ) ) {
			return new self();
		}
	}

	public function __construct() {
		if ( is_admin() ) {
			add_action( 'admin_menu', ['Pochirin', 'set_plugin_menu' ] );
			add_action( 'admin_enqueue_scripts', ['Pochirin', 'load_scripts' ] );
			add_action( 'wp_ajax_' . self::AJAX_ACTION, ['Pochirin', 'do_ajax' ] );
			require_once plugin_dir_path( __FILE__ ) . 'converter.php';
		}
	}

	public static function set_plugin_menu() {
		add_menu_page(
			'ポチリン',
			'ポチリン',
			'manage_options',
			self::MENU_SLUG,
			['Pochirin', 'show_about_plugin' ],
			'dashicons-hammer',
			80
		);
	}

	public static function load_scripts( $hook_suffix ) {
		if ( false === strpos( $hook_suffix, self::MENU_SLUG ) ) return;

		wp_enqueue_style( 'pochirin-style', plugins_url( '/assets/style.css', __FILE__ ), [], self::VERSION );
		wp_enqueue_script( 'pochirin-script', plugins_url( '/assets/script.js', __FILE__ ), [], self::VERSION, true );
		wp_localize_script( 'pochirin-script', 'pochirinVars', [
			'ajaxUrl'    => admin_url( 'admin-ajax.php' ),
			'ajaxAction' => self::AJAX_ACTION,
			'nonce'      => wp_create_nonce( self::NONCE_KEY ),
		] );
	}

	public static function show_about_plugin() {
		?>
		<div class="wrap pochirin-wrap">
			<h1>ポチリン</h1>
			<div id='message'><p>Rinkerの商品リンク関連のデータをポチップのデータ形式へ変換します。</p></div>
			<div class="pochirin-note">
				<ul>
					<li>データを変換できるのは、Amazonまたは楽天から検索された商品のみです。フリーリンクは変換できません。</li>
					<li>各商品データの「自由URLボタン」は最大2つまで引き継ぐことができます。</li>
					<li>
						ショートコードやブロックのオプションで設定できる項目を全て引き継ぐことはできません。<br>
						<code>title</code>と<code>brand</code>のみ引継ぎ可能です。
					</li>
					<li>データ変換後、商品カテゴリーは管理画面で正常に表示されないことがありますが、商品カテゴリーをどれか適当に空更新していただくと正常に表示されます。</li>
				</ul>
			</div>
			<div class="pochirin-alert">
				一度変換を行ったら復元はできません。
				<br>
				必ずバックアップを取り、あらかじめテスト環境で試してから変換を行ってください。
				<br>
				データ破損など、何が起こっても一切の責任を負いかねます。
			</div>
			<div id="converter">
				<div class="pochirin-loader">
					<div class="__img" role="status">Loading...</div>
					<p  class="__txt" style="margin: 7px;">変換中...</p>
				</div>

				<div class="pochirin-form">
					<div class="priority_btn_wrapper">
						<label for="priority_btn">優先して引き継ぐ自由ボタンの番号① : </label>
						<select name="priority_btn" id="priority_btn">
							<option value="1" selected>自由URLボタン1</option>
							<option value="2">自由URLボタン2</option>
							<option value="3">自由URLボタン3</option>
							<option value="4">自由URLボタン4</option>
						</select>
					</div>
					<div class="priority_btn_wrapper">
						<label for="priority_btn_2">優先して引き継ぐ自由ボタンの番号② : </label>
						<select name="priority_btn_2" id="priority_btn_2">
							<option value="1">自由URLボタン1</option>
							<option value="2" selected>自由URLボタン2</option>
							<option value="3">自由URLボタン3</option>
							<option value="4">自由URLボタン4</option>
						</select>
					</div>
					<p class="__help">（変換前の商品データに指定された自由ボタンがない場合は、その他の最も番号の若いボタンが引き継がれます。）</p>
					<button id="pochirin_submit" class="button button-primary button-large">RinkerからPochippへデータを変換する</button>
				</div>
			</div>
			<div id="dump-area"></div>
		</div>
		<?php
	}

	public static function do_ajax() {
		if ( ! wp_verify_nonce( $_POST['nonce'], self::NONCE_KEY ) ) {
			wp_die( json_encode( [ 'isSucceed' => 0 ] ) );
		}

		$priority_btns = explode( ',', $_POST['priority_btns'] );

		if ( self::IS_TEST ) ob_start();
		pochirin__replace_tax();
		pochirin__replace_db( $priority_btns );
		pochirin__replace_block();
		pochirin__replace_shortcode();

		if ( self::IS_TEST ) {
			$dump = ob_get_clean();
			wp_die( json_encode( [
				'isSucceed' => 1,
				'dump'      => $dump,
			] ) );
		} else {
			wp_die( json_encode( ['isSucceed' => 1 ] ) );
		}
	}
}
