<?php

/**
 * タクソノミーの変換
 */
function pochirin__replace_tax() {

	if ( Pochirin::IS_TEST ) {
		$categories = get_terms( 'yyi_rinker_cat', [
			'hide_empty' => false,
			'fields'     => 'ids',
		] );

		echo '<br><hr><br>';
		echo '▼ 以下のタームを変換';
		var_dump( $categories );
		return;
	}

	global $wpdb;
	$from = 'yyi_rinker_cat';
	$to   = 'pochipp_cat';
	$wpdb->query( $wpdb->prepare( "
		UPDATE `{$wpdb->term_taxonomy}`
		SET `taxonomy` = %s
		WHERE `taxonomy` = %s
	", $to, $from ) );
}


/**
 * 管理データの変換
 */
function pochirin__replace_db( $priority_btns ) {
	$the_query = new \WP_Query( [
		'post_type'              => [ 'yyi_rinker' ],
		'no_found_rows'          => true,
		'posts_per_page'         => Pochirin::NUM_OF_CONVERT,
	] );
	if ( $the_query->have_posts() ) :
		while ( $the_query->have_posts() ) :
			$the_query->the_post();
			$post_id = get_the_ID();

			// どのショップで検索されたか
			$shop_val  = get_post_meta( $post_id, 'yyi_rinker_search_shop_value', true );
			$shop_type = [
				'10' => 'amazon',
				'21' => 'rakuten',
				// '6'  => 'custom',
			];
			$searched_at = $shop_type[ $shop_val ] ?? '';
			if ( ! $searched_at ) {
				continue;
			}

			// 'pochipp_data'
			$new_pochipp_data = [
				'searched_at' => $searched_at,
			];

			// 単純な変換でいけるもの
			$convert_data = [
				'yyi_rinker_asin'             => 'asin',
				'yyi_rinker_rakuten_itemcode' => 'itemcode',
				'yyi_rinker_keyword'          => 'keywords',
				'yyi_rinker_amazon_title_url' => 'amazon_affi_url',
				'yyi_rinker_brand'            => 'info',
				'yyi_rinker_price'            => 'price',
				'yyi_rinker_price_at'         => 'price_at',
			];
			foreach ( $convert_data as $old_key => $new_key ) {
				$old_val = get_post_meta( $post_id, $old_key, true );
				if ( $old_val ) {
					$new_pochipp_data[ $new_key ] = $old_val;
				}
			}

			// 楽天の詳細ページURL
			$rakuten_url = get_post_meta( $post_id, 'yyi_rinker_rakuten_title_url', true );
			if ( $rakuten_url ) {
				$new_pochipp_data['rakuten_detail_url'] = pochirin__get_rakuten_url( $rakuten_url );
			}

			// 画像
			$img_url = get_post_meta( $post_id, 'yyi_rinker_l_image_url', true )
				?: get_post_meta( $post_id, 'yyi_rinker_m_image_url', true )
				?: get_post_meta( $post_id, 'yyi_rinker_s_image_url', true );

			if ( 'amazon' === $searched_at ) {
				$new_pochipp_data['image_url'] = $img_url;
			} elseif ( 'rakuten' === $searched_at ) {
				$img_url                       = substr( $img_url, 0, strcspn( $img_url, '?' ) );
				$new_pochipp_data['image_url'] = $img_url;
			}

			// カスタムボタン
			$btns = pochirin__get_custom_btn( $post_id, $priority_btns );
			if ( ! empty( $btns ) ) {
				$new_pochipp_data = array_merge( $new_pochipp_data, $btns );
			}

			if ( Pochirin::IS_TEST ) {
				echo '<br><hr><br>';
				echo '▼ 変換後データ';
				var_dump( $new_pochipp_data );
			} else {
				// 投稿データ更新
				wp_update_post( [
					'ID'           => $post_id,
					'post_content' => '<!-- wp:pochipp/setting /-->',
					'post_type'    => 'pochipps',
				] );

				// メタデータ更新
				update_post_meta( $post_id, \POCHIPP::META_SLUG, json_encode( $new_pochipp_data, JSON_UNESCAPED_UNICODE ) );

				// yyi_rinker_xxx を全て削除
				$all_meta = get_post_custom( $post_id );
				foreach ( $all_meta as $key => $value ) {
					if ( false !== strpos( $img_url, 'yyi_rinker_' ) ) {
						delete_post_meta( $post_id, $key );
					}
				}
			}
		endwhile;
	endif;
	wp_reset_postdata();
}


/**
 * ブロックの変換
 */
function pochirin__replace_block() {

	$query_args = [
		'post_type'              => ['any' ],
		'no_found_rows'          => true,
		'update_post_term_cache' => false, // 投稿のタクソノミーを使わない
		'update_post_meta_cache' => false, // 投稿のmetaを使わない
		'posts_per_page'         => -1, // 全部取得
	];

	if ( Pochirin::IS_TEST_ID ) {
		$query_args['p'] = Pochirin::IS_TEST_ID;
	} else {
		$query_args['s'] = 'wp:rinkerg/gutenberg-rinker'; // rinkerブロックがある記事を検索
	}
	$the_query = new \WP_Query( $query_args );

	if ( $the_query->have_posts() ) :
		while ( $the_query->have_posts() ) :
			$the_query->the_post();

			$post    = get_post();
			$post_id = get_the_ID();
			$content = $post->post_content;

			// フラグリセット
			Pochirin::$is_changed = false;

			$regex       = '/<!-- wp:rinkerg\/gutenberg-rinker(.*?)-->(.*?)<!-- \/wp:rinkerg\/gutenberg-rinker -->/s';
			$new_content = preg_replace_callback( $regex, function( $matches ) {

				$attrs = trim( $matches[1] ); // ブロックのattributes
				$code  = $matches[2]; // ブロックのコンテンツ

				if ( Pochirin::IS_TEST ) {
					echo '<br><hr><br>';
					var_dump( $matches[0] ); // phpcs:ignore
				}

				// idを取得
				$the_id = pochirin__get_data_from_attrs( $attrs, 'post_id' );

				// id取れなければそのままreturn
				if ( ! $the_id ) {
					return $matches[0];
				}

				// 上書きタイトルを取得
				// memo: ブロックのショートコード側に入力すると 't' になるバグがあって使われてなさそうなので、ほぼ attrs のチェックだけで良さそう
				$the_title = pochirin__get_data_from_attrs( $attrs, 'title' );
				// if ( ! $the_title || 't' === $the_title ) {
				// 	$the_title = pochirin__get_data_from_code( $code, 'title' );
				// }

				// 上書きブランドを取得
				// memo: ブランドの上書きは今のところショートコードでのみ可能
				$the_brand = pochirin__get_data_from_code( $code, 'brand' );
				// $the_brand = str_replace( '"', '\u0022', $the_brand );

				// Pochippのデータへ変換
				$pochipp_attrs = '"pid":' . $the_id;
				if ( $the_title ) {
					$pochipp_attrs .= ',"title":"' . $the_title . '"';
				}
				if ( $the_brand ) {
					$pochipp_attrs .= ',"info":"' . $the_brand . '"';
				}
				if ( class_exists( 'Pochipp_Pro' ) ) {
					$pochipp_attrs .= ',"isCount":true,"cvKey":"' . pochirin__get_random_cvkey() . '"';
				}

				$pochipp_data = '<!-- wp:pochipp/linkbox {' . $pochipp_attrs . '} /-->';
				if ( Pochirin::IS_TEST ) {
					var_dump( $pochipp_data );
				} else {
					Pochirin::$is_changed = true;
				}
				return $pochipp_data;

			}, $content);

			// 内容に変更があれば更新
			if ( Pochirin::$is_changed ) {
				wp_update_post( [
					'ID'           => $post_id,
					'post_content' => $new_content,
				] );
			}

		endwhile;
	endif;
	wp_reset_postdata();
}


/**
 * ショートコードの変換
 * str_replace( 'post_id=', 'id=', $attrs ) とかでもいい？ -> 不要な情報が残ってしまう
 */
function pochirin__replace_shortcode() {

	$query_args = [
		'post_type'              => ['any' ],
		'no_found_rows'          => true,
		'update_post_term_cache' => false, // 投稿のタクソノミーを使わない
		'update_post_meta_cache' => false, // 投稿のmetaを使わない
		'posts_per_page'         => -1, // 全部取得
	];

	if ( Pochirin::IS_TEST_ID ) {
		$query_args['p'] = Pochirin::IS_TEST_ID;
	} else {
		$query_args['s'] = '[itemlink'; // rinkerショートコードがある記事を検索
	}
	$the_query = new \WP_Query( $query_args );

	if ( $the_query->have_posts() ) :
		while ( $the_query->have_posts() ) :
			$the_query->the_post();

			$post    = get_post();
			$post_id = get_the_ID();
			$content = $post->post_content;

			// フラグリセット
			Pochirin::$is_changed = false;

			$regex       = '/\[itemlink(.*?)\]/s';
			$new_content = preg_replace_callback( $regex, function( $matches ) {

				$attrs = trim( $matches[1] ); // ショートコードの属性

				if ( Pochirin::IS_TEST ) {
					echo '<br><hr><br>';
					var_dump( $matches[0] ); // phpcs:ignore
				}

				// idを取得
				$the_id = pochirin__get_data_from_code( $attrs, 'post_id' );

				// id取れなければそのままreturn
				if ( ! $the_id ) {
					return $matches[0];
				}

				// 上書きタイトルを取得
				$the_title = pochirin__get_data_from_code( $attrs, 'title' );

				// 上書きブランドを取得
				$the_brand = pochirin__get_data_from_code( $attrs, 'brand' );
				// $the_brand = str_replace( '"', '\u0022', $the_brand );

				// Pochippのデータへ変換
				$pochipp_attrs = 'id="' . $the_id . '"';
				if ( $the_title ) {
					$pochipp_attrs .= ' title="' . $the_title . '"';
				}
				if ( $the_brand ) {
					$pochipp_attrs .= ' info="' . $the_brand . '"';
				}

				$pochipp_data = '[pochipp ' . $pochipp_attrs . ']';
				if ( Pochirin::IS_TEST ) {
					var_dump( $pochipp_data );
				} else {
					Pochirin::$is_changed = true;
				}
				return $pochipp_data;

			}, $content);

			// 内容に変更があれば更新
			if ( Pochirin::$is_changed ) {
				wp_update_post( [
					'ID'           => $post_id,
					'post_content' => $new_content,
				] );
			}

		endwhile;
	endif;
	wp_reset_postdata();
}


// attributesのコメントデータから抽出
function pochirin__get_data_from_attrs( $attrs, $s ) {
	preg_match( '/"' . $s . '":"([^"]*)"/', $attrs, $matches );
	return $matches[1] ?? '';
}


// ショートコードのオプションから抽出
function pochirin__get_data_from_code( $cpde, $s ) {
	preg_match( '/' . $s . '="([^"]*)"/', $cpde, $matches );
	// preg_match( '/' . $s . '=\'([^\']*)\'/', $cpde, $matches );
	return $matches[1] ?? '';
}


// 楽天のURL抽出
function pochirin__get_rakuten_url( $url ) {
	preg_match( '/\?pc=([^&]*)&m/', $url, $matches );
	$url = $matches[1] ?? '';
	return rawurldecode( $url );
}

// カスタムボタン抽出
function pochirin__get_custom_btn( $post_id, $priorities ) {
	$btns = [];

	// 各自由ボタンのURLがあるかをとりあえず先に調べる
	for ( $i = 1; $i < 5; $i++ ) {
		$btn_url = get_post_meta( $post_id, "yyi_rinker_free_url_{$i}", true );
		if ( $btn_url ) {
			$btns[ (string) $i ] = $btn_url;
		}
	}

	// 一つもなければ
	if ( empty( $btns ) ) return [];
	// 一つしかなければ
	if ( count( $btns ) === 1 ) {
		$index = pochirin__get_first_key( $btns );
		return [
			'custom_btn_url'  => $btns[ $index ],
			'custom_btn_text' => get_post_meta( $post_id, "yyi_rinker_free_url_label_${index}_column", true ),
		];
	}

	// 次に、優先ボタンを探す
	$index_list = pochirin__search_btn_index( $btns, $priorities );
	return [
		'custom_btn_url'    => $btns[ $index_list[0] ],
		'custom_btn_text'   => get_post_meta( $post_id, "yyi_rinker_free_url_label_${index_list[0]}_column", true ),
		'custom_btn_url_2'  => $btns[ $index_list[1] ],
		'custom_btn_text_2' => get_post_meta( $post_id, "yyi_rinker_free_url_label_${index_list[1]}_column", true ),
	];
}

function pochirin__search_btn_index( $btns, $priorities ) {
	$priority_list = $priorities;
	// 先頭から優先順位の高いpriority_listを作成
	foreach ( array_keys( $btns ) as $key ) {
		if ( in_array( (string) $key, $priorities ) ) {
			continue;
		}
		array_push( $priority_list, (string) $key );
	}

	$index_list = [];
	foreach ( $priority_list as $value ) {
		// ボタンがセットされていないかカスタムボタンが２個になればcontinue
		if ( ! isset( $btns[ $value ] ) || count( $index_list ) === 2 ) {
			continue;
		}
		array_push( $index_list, $value );
	}
	return $index_list;
}

// 配列の最初のキーを返す
function pochirin__get_first_key( $array ) {
	reset( $array );
	return key( $array );
}

// 擬似的にcvkeyを付与する
function pochirin__get_random_cvkey() {
    $length = 4; // 4bytes
    return bin2hex(random_bytes($length));
}
