const COMPLETE_MESSAGE = {
	SUCCESS: '<div class="notice updated"><p>変換が完了しました。変換を確認後、プラグインを停止し削除してください。</p></div>',
	FAILED: '<div class="notice error"><p>変換に失敗しました。再度お試しください。</p></div>',
};

document.querySelector('#pochirin_submit').addEventListener('click', (event) => {
	// buttonを非活性・ローダーを表示する
	const button = event.target;
	button.disabled = true;
	document.querySelector('#converter').classList.add('-doing');

	const priorityBtn1 = document.querySelector('#priority_btn').value;
	const priorityBtn2 = document.querySelector('#priority_btn_2').value;

	// 変換処理を実行
	const url = window.pochirinVars.ajaxUrl;
	const nonce = window.pochirinVars.nonce;
	const action = window.pochirinVars.ajaxAction;
	
	const params = new URLSearchParams();
	params.append('action', action);
	params.append('nonce', nonce);
	params.append('priority_btns', [...new Set([priorityBtn1, priorityBtn2])]);
	fetch(url, {
		method: 'POST',
		cache: 'no-cache',
		body: params,
	})
	.then(res => {
		if (res.ok) {
			return res.json();
		}
		throw new Error('error occured');
	})
	.then(data => {
		const message = data.isSucceed ? COMPLETE_MESSAGE.SUCCESS : COMPLETE_MESSAGE.FAILED;
		document.querySelector('#message').innerHTML = message;
		if(data.dump){
			document.querySelector('#dump-area').innerHTML = data.dump;
		}
	})
	.catch(() => {
		document.querySelector('#message').innerHTML = COMPLETE_MESSAGE.FAILED;
	})
	.finally(() => {
		button.disabled = false
		document.querySelector('#converter').classList.remove('-doing');
	});
});
