<?php
add_action('wp_ajax_pochireba', 'pochireba__convert_links');

function pochireba__convert_links() {
	if ( ! wp_verify_nonce( $_POST['nonce'], \Pochireba::NONCE_KEY ) ) {
		wp_die( json_encode( [ 'isSucceed' => 0 ] ) );
	}

	$the_query = new \WP_Query( [
		'post_type'              => ['post', 'page', 'wp_block' ],
		's'                      => 'wp:html', // htmlブロックがある記事を検索
		'no_found_rows'          => true,
		'update_post_term_cache' => false, // 投稿のタクソノミーを使わない
		'update_post_meta_cache' => false, // 投稿のmetaを使わない
		'posts_per_page'         => -1, // 全部取得
	] );
	
	if ( $the_query->have_posts() ) :
		while ( $the_query->have_posts() ) :
			$the_query->the_post();
			$post    = get_post();
			$post_id = get_the_ID();
			pochireba__update_post($post_id, pochireba__replace_post($post));
		endwhile;
	endif;
	wp_reset_postdata();

	wp_die(json_encode(['isSucceed' => 1]));
}

function pochireba__replace_post($post) {
	$index = 0;
	$html = $post->post_content;
	$regex = '/<!-- wp:html -->(.*?)<!-- \/wp:html -->/s';
	return preg_replace_callback($regex, function($matches) {
		$node = $matches[1];
		// カエレバリンクでないときはそのまま返す
		if (strpos($node, 'class="kaerebalink-box"') === false) {
			return '<!-- wp:html -->' . $node . '<!-- /wp:html -->';
		}

		$entry = pochireba__get_info_from_kaereba($node);
		return $pochipp_text = pochireba__gen_pochipp_text(
			$entry['title'],
			$entry['detail'],
			$entry['img'],
			$entry['searched_at'],
			$entry['keyword'],
			$entry['main']
		);
	}, $html);
}

function pochireba__update_post($id, $content) {
	$post = [
		'ID' => $id,
		'post_content' => $content,
	];
	wp_update_post($post);
}

function pochireba__gen_pochipp_text($title, $detail, $image, $searched_at, $keyword, $main) {
	$data = [
		"title" => $title,
		"keywords" => $keyword ?: $title,
		"searched_at" => $searched_at,
		"info" => $detail,
		"image_url" => $image,
	];
	$data["{$searched_at}_detail_url"] = $main;
	$result = json_encode($data, JSON_UNESCAPED_UNICODE); 
	return "<!-- wp:pochipp/linkbox {$result} /-->";
}

function pochireba__get_info_from_kaereba($htmlText) {
	$dom = new DOMDocument;
	@$dom->loadHTML(mb_convert_encoding($htmlText, 'HTML-ENTITIES', 'auto'));
	$xpath = new DOMXpath($dom);

	$elements = $xpath->query('//div[@class="kaerebalink-box"]');
	$element = $elements[0];
	$main_href = pochireba__get_href($xpath->evaluate('string(.//div[@class="kaerebalink-name"]/a/@href)', $element));
	$amazon = $xpath->evaluate('string(.//div[@class="shoplinkamazon"]/a/@href)', $element);
	$rakuten = $xpath->evaluate('string(.//div[@class="shoplinkrakuten"]/a/@href)', $element);
	$yahoo = $xpath->evaluate('string(.//div[@class="shoplinkyahoo"]/a/@href)', $element);
	$keyword = 
		pochireba__get_by_amazon($amazon) 
		?: pochireba__get_by_rakuten($rakuten) 
		?: pochireba__get_by_yahoo($yahoo);
	$searched_at = pochireba__get_searched_at($xpath->evaluate('string(.//div[@class="kaerebalink-name"]/a/@href)', $element));

	// kaerebaより必要な情報を取得
	return [
		'img' => pochireba__get_image_url($xpath->evaluate('string(.//img/@src)', $element)),
		'title' => $xpath->evaluate('string(.//div[@class="kaerebalink-name"]/a)', $element),
		'detail' => trim($xpath->evaluate('string(.//div[@class="kaerebalink-detail"])', $element)),
		'searched_at' => $searched_at,
		'keyword' => $keyword,
		'main' => $main_href,
	];
}

function pochireba__get_href($href) {
	$url = urldecode($href);
	$query = preg_match('/url=[^&]*/', $url, $matches);
	return explode('=', $matches[0])[1];
}

function pochireba__get_image_url($href) {
	return explode('?', $href)[0];
}

function pochireba__get_searched_at($href) {
	return strpos($href, 'yahoo') !== false ? 'yahoo' : 'rakuten';
}

function pochireba__get_by_amazon($path) {
	preg_match('/keywords=[^&]*/', urldecode($path), $matches);
	return count($matches) !== 0 ? explode('=', urldecode($matches[0]))[1] : '';
}

function pochireba__get_by_rakuten($path) {
	preg_match('/mall\/[^\/]*/', urldecode($path), $matches);
	return count($matches) !== 0 ? explode('/', urldecode($matches[0]))[1] : '';
}

function pochireba__get_by_yahoo($path) {
	preg_match('/p=[^&]*/', urldecode($path), $matches);
	return count($matches) !== 0 ? explode('=', urldecode($matches[0]))[1] : '';
}
