<?php
/*
 * Plugin Name: Pochimoshi
 * Plugin URI: https://pochipp.com/
 * Description: もしもかんたんリンクをPochippに変換するプラグイン
 * Version: 0.1.0
 * Author: ひろ
 * Author URI: https://pochipp.com/
 * License: GPL3 or later
 * License URI: https://www.gnu.org/licenses/gpl-3.0.html
 */

if ( ! defined( 'ABSPATH' ) ) exit;

add_action('init', 'Pochimoshi::init');

class Pochimoshi {

	const VERSION   = '0.1.1';
	const NONCE_KEY = 'pochimoshi-nonce';

	static function init() {
		return new self();
	}

	function __construct() {
		if (is_admin()) {
			add_action('admin_menu', [$this, 'set_plugin_menu']);
			add_action('admin_enqueue_scripts', [$this, 'load_scripts']);
			require_once plugin_dir_path( __FILE__ ) . 'converter.php';
		}
	}

	function set_plugin_menu() {
		add_menu_page(
			'ポチもし',
			'ポチもし',
			'manage_options',
			'pochimoshi',
			[$this, 'show_about_plugin'],
			'dashicons-hammer',
			80
		);
	}

	function load_scripts( $hook_suffix ) {
		if ( false === strpos( $hook_suffix, 'pochimoshi' ) ) return;
		wp_enqueue_style( 'pochimoshi-style', plugins_url( '/assets/style.css', __FILE__ ), [], self::VERSION );
		wp_enqueue_script( 'pochimoshi-script', plugins_url( '/assets/script.js', __FILE__ ), [], self::VERSION, true );
		wp_localize_script( 'pochimoshi-script', 'pochimoshiVars', [
			'ajaxUrl' => admin_url( 'admin-ajax.php' ),
			'nonce'   => wp_create_nonce( self::NONCE_KEY ),
		] );
	}

	function show_about_plugin() {
		?>
		<div>
			<h1>ポチもし</h1>
			<div id='message'><p>もしもかんたんリンクをポチップリンクに変換します</p></div>
			<div class="pochimoshi-note">
				<ul>
					<li>データの構造によって変換が上手くいかないことがあります。</li>
					<li>もしもかんたんリンクの情報を元にポチップブロックを生成しているため、価格表示・商品の再検索など一部の機能が利用できません。</li>
					<li>カスタムボタンが3つ以上ある場合、先頭の2つのみポチップブロックへの変換を行います。</li>
				</ul>
			</div>
			<div class="pochimoshi-alert">
				一度変換を行ったら復元はできません。
				<br>
				必ずバックアップを取り、あらかじめテスト環境で試してから変換を行ってください。
				<br>
				データ破損など、何が起こっても一切の責任を負いかねます。
			</div>
			<div id="converter" class="flex display-none">
				<div class="loader" role="status">Loading...</div>
				<p style="margin: 7px;">変換中...</p>
			</div>
			<button id="pochimoshi__button" class="button button-primary button-large">変換する</button>
		</div>
		<?php
	}
}
