<?php
add_action('wp_ajax_pochimoshi', 'pochimoshi__convert_links');

function pochimoshi__convert_links() {
	if ( ! wp_verify_nonce( $_POST['nonce'], \Pochimoshi::NONCE_KEY ) ) {
		wp_die( json_encode( [ 'isSucceed' => 0 ] ) );
	}

	$the_query = new \WP_Query( [
		'post_type'              => ['post', 'page', 'wp_block' ],
		's'                      => 'msmaflink', // もしもかんたんリンクがある投稿を検索
		'no_found_rows'          => true,
		'update_post_term_cache' => false, // 投稿のタクソノミーを使わない
		'update_post_meta_cache' => false, // 投稿のmetaを使わない
		'posts_per_page'         => -1, // 全部取得
	] );
	
	if ( $the_query->have_posts() ) :
		while ( $the_query->have_posts() ) :
			$the_query->the_post();
			$post    = get_post();
			$post_id = get_the_ID();
			pochimoshi__update_post($post_id, pochimoshi__replace_post($post));
		endwhile;
	endif;
	wp_reset_postdata();

	wp_die(json_encode(['isSucceed' => 1]));
}

function pochimoshi__replace_post($post) {
	$html = $post->post_content;
	$regex = '/<!-- wp:html -->(.*?)<!-- \/wp:html -->/s';
	return preg_replace_callback($regex, function($matches) {
		$node = $matches[1];
		// もしもかんたんリンクでないときはそのまま返す
		if (strpos($node, 'msmaflink') === false) {
			return '<!-- wp:html -->' . $node . '<!-- /wp:html -->';
		}

		// JSONを取得
		preg_match('/msmaflink\((.*)\);/', $node, $json_matches);
		$json = json_decode($json_matches[1], true);
		// JSONが想定外のフォーマットのときはそのまま返す
		if (!$json) {
			return '<!-- wp:html -->' . $node . '<!-- /wp:html -->';
		}

		$entry = pochimoshi__get_info_from_moshimo($json);
		// moshimoからデータを取得できなかったときはそのまま返す
		if (count($entry) === 0) {
			return '<!-- wp:html -->' . $node . '<!-- /wp:html -->';
		}

		return $pochipp_text = pochimoshi__gen_pochipp_text(
			$entry['title'],
			$entry['detail'],
			$entry['img'],
			$entry['searched_at'],
			$entry['keyword'],
			$entry['main'],
			$entry['custom'],
		);
	}, $html);
}

function pochimoshi__update_post($id, $content) {
	$post = [
		'ID' => $id,
		'post_content' => $content,
	];
	wp_update_post($post);
}

function pochimoshi__gen_pochipp_text($title, $detail, $image, $searched_at, $keyword, $main, $custom_links) {
	$data = [
		"title" => $title,
		"keywords" => $keyword ?: $title,
		"searched_at" => $searched_at,
		"info" => $detail,
		"image_url" => $image,
	];
	$data["{$searched_at}_detail_url"] = $main;
	if ($searched_at === 'amazon') {
		$path = explode('/', $main);
		$data["asin"] = end($path);
	}
	if (count($custom_links) > 0) {
		$data["custom_btn_text"] = $custom_links[0]['title'];
		$data["custom_btn_url"] = $custom_links[0]['url'];
		$data["custom_btn_text_2"] = $custom_links[1] !== null ? $custom_links[1]['title'] : '';
		$data["custom_btn_url_2"] = $custom_links[1] !== null ? $custom_links[1]['url'] : '';
	}
	if (class_exists( 'Pochipp_Pro' )) {
		$data["isCount"] = true;
		$data["cvKey"] = pochimoshi__get_random_cvkey();
	}

	$result = json_encode($data, JSON_UNESCAPED_UNICODE); 
	return "<!-- wp:pochipp/linkbox {$result} /-->";
}

function pochimoshi__get_info_from_moshimo($json) {
	if (
		!array_key_exists('d', $json)
		|| !array_key_exists('c_p', $json)
		|| !array_key_exists('p', $json)
		|| !array_key_exists('n', $json)
		|| !array_key_exists('u', $json)
		|| !array_key_exists('b_l', $json)
		|| !array_key_exists('t', $json['u'])
		|| !array_key_exists('u', $json['u'])
		|| count($json['p']) === 0
		|| ($json['u']['t'] !== 'amazon' && $json['u']['t'] !== 'rakuten')
	) {
		return [];
	}

	$custom_links = array_filter($json['b_l'], function($item) {
		return $item['u_url'] !== null
			&& $item['u_url'] !== ''
			&& strpos($item['u_url'], 'amazon') === false
			&& strpos($item['u_url'], 'rakuten') === false
			&& strpos($item['u_url'], 'yahoo') === false;
	});
	// moshimoより必要な情報を取得
	return [
		'img' => "{$json['d']}{$json['c_p']}{$json['p'][0]}",
		'title' => $json['n'],
		'detail' => '',
		'searched_at' => $json['u']['t'],
		'keyword' => $json['n'],
		'main' => $json['u']['u'],
		'custom' => array_map(function($item) {
			return [
				'title' => $item['u_tx'],
				'url' => $item['u_url'],
			];
		}, array_values($custom_links)),
	];
}

// 擬似的にcvkeyを付与する
function pochimoshi__get_random_cvkey() {
	$length = 4; // 4bytes
	return bin2hex(random_bytes($length));
}
