const COMPLETE_MESSAGE = {
	SUCCESS: '<div class="notice updated"><p>変換が完了しました。変換を確認後、プラグインを停止し削除してください</p></div>',
	FAILED: '<div class="notice error"><p>変換に失敗しました。再度お試しください</p></div>',
};

document.querySelector('#pochimoshi__button').addEventListener('click', (event) => {
	// buttonを非活性・ローダーを表示する
	const button = event.target;
	button.disabled = true;
	document.querySelector('#converter').classList.remove('display-none');

	// 変換処理を実行
	const url = window.pochimoshiVars.ajaxUrl;
	const nonce = window.pochimoshiVars.nonce;
	const params = new URLSearchParams();
	params.append('action', 'pochimoshi');
	params.append('nonce', nonce);
	fetch(url, {
		method: 'POST',
		cache: 'no-cache',
		body: params,
	})
	.then(res => {
		if (res.ok) {
			return res.json();
		}
		throw new Error('error occured');
	})
	.then(data => {
		const message = data.isSucceed ? COMPLETE_MESSAGE.SUCCESS : COMPLETE_MESSAGE.FAILED;
		document.querySelector('#message').innerHTML = message;
	})
	.catch(() => {
		document.querySelector('#message').innerHTML = COMPLETE_MESSAGE.FAILED;
	})
	.finally(() => {
		button.disabled = false
		document.querySelector('#converter').classList.add('display-none');
	});
});
