<?php
namespace POCHIPP_ASSIST;

if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * APIから検索
 */
remove_action( 'wp_ajax_pochipp_search_amazon', '\POCHIPP\search_from_amazon_api' );
add_action( 'wp_ajax_pochipp_search_amazon', '\POCHIPP_ASSIST\search_from_amazon_noapi' );


/**
 * AmazonAPIから商品データを取得する
 */
function search_from_amazon_noapi() {

	if ( ! \POCHIPP\check_ajax_nonce() ) {
		wp_die( json_encode( [
			'error' => [
				'code'    => 'nonce error',
				'message' => '不正なアクセスです。',
			],
		] ) );
	};

	$keywords = \POCHIPP::array_get( $_GET, 'keywords', '' );
	$only     = \POCHIPP::array_get( $_GET, 'only', '' );

	// 登録済み商品
	$registerd_items = [];
	if ( ! $only ) {
		$registerd_items = \POCHIPP::get_registerd_items( [
			'keywords' => $keywords,
			'count'    => 2, // memo: ２個まで取得。<- 少ない？
		] );
	}

	// 検索結果
	$searched_items = \POCHIPP_ASSIST\get_item_data_noapi( $keywords );

	wp_die( json_encode( [
		'registerd_items' => $registerd_items ?: [],
		'searched_items'  => $searched_items ?: [],
	] ) );
}


/**
 * 商品データを取得
 */
function get_item_data_noapi( $keywords = '' ) {

	// 空白の場合
	if ( ! trim( $keywords ) ) {
		return [
			'error' => [
				'code'    => 'null',
				'message' => '検索キーワードが空です。',
			],
		];
	}

	$host    = 'https://asia-northeast1-pochipp-assist-api.cloudfunctions.net/search_amazon';
	$headers = [
		'Content-Type' => 'application/json',
	];
	$body    = [
		'keyword' => $keywords,
		'domain'  => $_SERVER['SERVER_NAME'],
		'token'   => '2yk32kQ4IipwMYeD',
	];

	// API接続
	$response = wp_remote_post(
		$host,
		[
			// 'method'      => 'POST',
			// 'sslverify'   => true,
			'timeout'     => 20,
			'redirection' => 5,
			'headers'     => $headers,
			'body'        => wp_json_encode( $body ),
		]
	);

	// エラーがあれば
	if ( is_wp_error( $response ) ) {
		return [
			'error' => [
				'code'    => 'is_wp_error',
				'message' => $response->get_error_message(),
			],
		];
	}

	// レスポンスをデコード
	$response_arr = json_decode( $response['body'], true );

	// decode失敗時
	if ( ! $response_arr || ! is_array( $response_arr ) ) {
		return [
			'error' => [
				'code'    => 'decode error',
				'message' => 'APIから正しいデータが返ってきませんでした。',
			],
		];
	}

	$result_code = $response_arr['code'] ?? '';
	if ( 200 !== $result_code ) {
		return [
			'error' => [
				'code'       => $response_arr['code'],
				'message'    => $response_arr['message'] ?? '不明なエラー',
			],
		];
	}


	$result_data = $response_arr['body'] ?? [];

	if ( empty( $result_data ) ) {
		return [
			'error' => [
				'code'       => 'no result',
				'message'    => '商品データが見つかりませんでした。',
			],
		];
	}

	// エラーがなければ、必要な商品データを取得
	return \POCHIPP_ASSIST\set_item_data_by_ASSIST( $result_data, $keywords );
}


/**
 * 商品データを整形
 */
function set_item_data_by_ASSIST( $result_data, $keywords ) {

	$items = [];
	foreach ( $result_data as $item ) {
		$data = [
			'keywords'    => $keywords,
			'searched_at' => 'amazon',
		];

		$asin          = $item['asin'] ?? '';
		$data['asin']  = $asin;
		$data['title'] = $item['title'] ?? '';

		// 価格
		$price            = $item['price'] ?? '';
		$data['price']    = (string) $price;
		$data['price_at'] = wp_date( 'Y/m/d H:i' );

		// 画像URL
		$data['image_url'] = $item['img'] ?? '';

		$items[] = $data;
	}
	return $items;
}
