<?php
/**
 * Plugin Name: Pochipp Assist
 * Plugin URI: https://pochipp.com/pochipp-assist/
 * Description: ポチップでPA-APIを使用せずにAmazonからの商品検索を可能にするプラグインです。
 * Author: ひろ
 * Version: 0.1.1
 * Author URI: https://pochipp.com/
 * License: GPL2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if ( ! defined( 'ABSPATH' ) ) exit;


/**
 * Ver.
 */
define( 'PCHPP_ASSIST_VERSION', ( defined( 'WP_DEBUG' ) && WP_DEBUG ) ? date( 'mdGis' ) : '0.1.0' );

/**
 * Define path, url
 */
define( 'PCHPP_ASSIST_URL', plugins_url( '/', __FILE__ ) );
define( 'PCHPP_ASSIST_PATH', plugin_dir_path( __FILE__ ) );;


/**
 * Start
 */
add_action( 'plugins_loaded', function() {

	add_filter( 'unzip_file_use_ziparchive', '__return_false' );

	if ( ! class_exists( 'POCHIPP' ) ) return;

	// Amazon検索を強制的に許可
	add_filter( 'pochipp_can_use_amazon_search', '__return_true' );

	// ファイル読み込み
	require_once PCHPP_ASSIST_PATH . 'inc/search_amazon_noapi.php';

	// Pochipp本体に入ってるのでそっち使う
	if ( class_exists( 'Puc_v4_Factory' ) ) {
		Puc_v4_Factory::buildUpdateChecker(
			'https://pochipp.com/plugin_versions/version_assist.json',
			PCHPP_ASSIST_PATH . 'pochipp_assist.php',
			'pochipp_assist'
		);
	}
}, 20 );
